'This program calculates all frequencies using pin 11 set to
'measure frequency & uses subroutines to print text at any position
'on a 2x16 LCD screen
'use printLCD (line number [1 or 2]),(place on line [0 to 15]),(text to print)

       SetPin 11,3:SetPin 1,1:SetPin 2,1	'set i/o pins for frequency or analog
       For i = 15 To 20 : SetPin i, 8 : Next i	'set I/O pins digital output
       initLCD	'initialise LCD
      Pause 2000	'Wait for freq measurement
loop1:
       f = Pin(11)	'get freq
       If f < 1 Then GoTo loop1	'freq can't be 0
       f$ = Str$(Cint(f))		'round value to nearest integer
       On Len(f$) GoSub d2,d2,d3,d4,d5,d6	'work out how to display
       f$ = f$ + Space$(8 - Len(f$))	'get ready to output to LCD
       printLCD 1,0,f$:printlcd 1,5,u$	'output to LCD

       p = 1000/f		'calcuate period in ms
       If p >= 1 Then	'work out how to display
              u$ = "mS "
       Else
              p = p*1000
              u$ = "uS "
       EndIf
       p$ = Str$(Cint(p))
       On Len(p$) GoSub p1d,p2d,p3d
       p$ = Str$(p)
       p$ = p$ + Space$(7 - Len(p$))
       printlcd 2,0,p$:printlcd 2,5,u$	'display on LCD

       level = Pin(1)/3.3*10:level$ =Str$( Cint(10*level)/10) 'read position of level pot
       level$ = level$ + Space$(3 - Len(level$))	'work out how to display
       u$ = " Vp-p"
       printlcd 2,8,level$:printlcd 2,11,u$	'display on LCD
       'Print f,p,level

       band = Pin(2)	'read band information
       If band > 2.75 Then
              band$ = "  band 4"
       ElseIf band > 1.65 Then
              band$ = "  band 3"
       ElseIf band > .55 Then
              band$ = "  band 2"
       Else
              band$ = "  band 1"
       EndIf
       printlcd 1,8,band$	'output band to LCD

       Pause 2000		'wait a bit 

GoTo loop1

p1d:
       p = Cint(100*p)/100
Return

p2d:
       p = Cint(10*p)/10
Return

p3d:
       p = Cint(p)
Return

d2:
       f = Cint(10*f)/10:f$ = Str$(f):u$ = " Hz "
Return

d3:
       f = Cint(f):f$ = Str$(f):u$ = " Hz "
Return

d4:
       f = 10*Cint(f/10):f$ = Str$(f/1000)
       u$ = "kHz "
Return

d5:
       f = 100*Cint(f/100):f$ = Str$(f/1000)
       u$ = "kHz "
Return

d6:
       f = 1000*Cint(f/1000):f$ = Str$(f)
       f$ = Left$(f$,3):u$ = "kHz "
Return

' Initialise the LCD
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Sub InitLCD
  LCD &B0011, 0:Pause 5                  ' reset
  LCD &B0011, 0:Pause 5                  ' reset
  LCD &B0011, 0:Pause 5             ' reset
  LCD &B0010, 0:Pause 5                 ' 4 bit mode
  LCD &B0010, 0:Pause 2: LCD &B1100,0:Pause 2 ' 4 bits, 2 lines
  LCD &B0000,0:Pause  2: LCD &B1100,0:Pause 2' display on, no cursor
  LCD &B0000,0:Pause 2:  LCD &B0110,0:Pause 2  ' increment on write
  LCD &B0000,0:Pause 2 : LCD &B0001,0:Pause 2    ' clear the disply
End Sub

'this subroutine can be called to clear display
Sub clearlcd
       lcd 0,0:Pause 2:lcd 1,0
End Sub

'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' Display a line on the LCD
' argument #1 is the line to be used (1 or 2)
' argument #2 is the position on line to display (0-15)
' argument #3 is text to display
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Sub PrintLCD (lin, place, text$ )
  Local i, c,position
  ' first send the cursor position (in two nibbles)
  position = &h80 + (lin - 1)*64 + place
  LCD Int(position/16),0 : LCD position,0

  ' then send the text character by character (two nibbles per character)
  For i = 1 To Len(text$)
    c = Asc(Mid$(text$, i, 1))
    LCD Int(c/16), 1 : LCD c, 1
  Next i
End Sub
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' Send the lower nibble to the LCD
' argument #1 is the nibble to send
' argument #2 is 1 if data, 0 if command
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Sub LCD(data1, Flag )
  Pin(15) = Flag
  Pin(17) = Data1 And 1
  Pin(18) = Data1 And 2
  Pin(19) = Data1 And 4
  Pin(20) = Data1 And 8
  Pin(16) = 1 :Pause 1: Pin(16) = 0
End Sub

